<?php
require_once 'api_helper.php';
if (empty($_SESSION['user_id'])) {
    header('Location: login.php'); exit;
}
$db = get_db();
$meStmt = $db->prepare('SELECT username, is_admin FROM users WHERE id = :id');
$meStmt->execute([':id' => $_SESSION['user_id']]);
$me = $meStmt->fetch(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css">
<title>Parts Research Dashboard</title>
</head>
<body>
<div class="topbar">
  <div>Welcome, <?php echo htmlspecialchars($me['username']); ?></div>
  <div><a href="logout.php">Sign out</a></div>
</div>
<div class="container">
  <h1>Parts Research</h1>
  <section>
    <h3>Quick check</h3>
    <form id="quickForm">
      <label>Part number or description<br><input id="q" name="q" required></label>
      <label>Local salvage cost (USD)<br><input id="local_cost" name="local_cost" type="number" step="0.01" value="0"></label>
      <button type="submit">Search sold history</button>
    </form>
    <div id="result"></div>
  </section>
  <section>
    <h3>Bulk upload (CSV)</h3>
    <form action="upload_csv.php" method="post" enctype="multipart/form-data">
      <input type="file" name="csvfile" accept=".csv" required>
      <button type="submit">Upload CSV</button>
    </form>
    <p>CSV format: <code>part_number,description,local_cost</code></p>
  </section>
  <?php if (!empty($_SESSION['is_admin'])): ?>
  <section>
    <h3>Admin</h3>
    <p><a href="users.php">Manage users</a></p>
  </section>
  <?php endif; ?>

  <section>
    <h3>Saved inventory</h3>
    <table>
      <thead><tr><th>Part</th><th>Desc</th><th>Local cost</th><th>Qty</th></tr></thead>
      <tbody>
<?php
$rows = $db->query('SELECT part_number,description,local_cost,qty FROM inventory ORDER BY added_at DESC LIMIT 50')->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $r) {
    echo '<tr><td>'.htmlspecialchars($r['part_number']).'</td><td>'.htmlspecialchars($r['description']).'</td><td>'.number_format($r['local_cost'],2).'</td><td>'.intval($r['qty']).'</td></tr>';
}
?>
      </tbody>
    </table>
  </section>
</div>
<script>
const form = document.getElementById('quickForm');
form.addEventListener('submit', async (e)=>{
  e.preventDefault();
  const q = document.getElementById('q').value;
  const local_cost = document.getElementById('local_cost').value || 0;
  const resDiv = document.getElementById('result');
  resDiv.innerHTML = 'Searching...';
  try {
    const r = await fetch('search.php', {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({q, local_cost})});
    const j = await r.json();
    if (j.error) { resDiv.innerHTML = '<div class="error">'+j.error+'</div>'; return; }
    let html = '<h4>Results for '+escapeHtml(q)+'</h4>';
    html += '<p>Median price: $'+(j.median_price || 0)+'</p>';
    html += '<p>Qty sold (90d): '+(j.sold_count || 0)+'</p>';
    html += '<p>Estimated profit: $'+(j.profit || 0)+'</p>';
    html += '<pre>'+JSON.stringify(j.raw, null, 2).slice(0,1000)+'</pre>';
    resDiv.innerHTML = html;
  } catch(e){ resDiv.innerHTML = '<div class="error">'+e.message+'</div>'; }
});
function escapeHtml(s){ return s.replace(/[&<>\"']/g, (c)=> ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":"&#39;"})[c]); }
</script>
</body>
</html>