<?php
require_once 'config.php';

if (file_exists(DB_FILE)) {
    echo "Database already exists at " . DB_FILE . " — delete it only if you want to reinitialize.";
    exit;
}

$db = new PDO('sqlite:' . DB_FILE);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Create tables
$db->exec("CREATE TABLE users (id INTEGER PRIMARY KEY AUTOINCREMENT, username TEXT UNIQUE, password_hash TEXT, is_admin INTEGER DEFAULT 0, created_at DATETIME DEFAULT CURRENT_TIMESTAMP);");

$db->exec("CREATE TABLE queries (id INTEGER PRIMARY KEY AUTOINCREMENT, part_number TEXT, description TEXT, local_cost REAL, result_json TEXT, cached_at INTEGER);");

$db->exec("CREATE TABLE inventory (id INTEGER PRIMARY KEY AUTOINCREMENT, part_number TEXT, description TEXT, local_cost REAL, qty INTEGER DEFAULT 1, added_at DATETIME DEFAULT CURRENT_TIMESTAMP);");


// Create default shared user using credentials from config.php
$shared_user = defined('SHARED_USERNAME') ? SHARED_USERNAME : 'user';
$shared_pwd = defined('SHARED_PASSWORD') ? SHARED_PASSWORD : bin2hex(random_bytes(4));
$hash = password_hash($shared_pwd, PASSWORD_DEFAULT);
$stmt = $db->prepare("INSERT INTO users (username, password_hash, is_admin) VALUES (:u,:p,0)");

$stmt->execute([':u' => $shared_user, ':p' => $hash]);

echo "Database initialized. Shared username: ".htmlspecialchars($shared_user)."\n";
echo "Shared password (copy it now) : <strong>".htmlspecialchars($shared_pwd)."</strong>\n";
echo "Then delete or restrict access to db_init.php for security.";

?>