<?php
require_once 'api_helper.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = $_POST['username'] ?? '';
    $p = $_POST['password'] ?? '';
    $db = get_db();
    $stmt = $db->prepare('SELECT id, password_hash, is_admin FROM users WHERE username = :u');
    $stmt->execute([':u' => $u]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row && password_verify($p, $row['password_hash'])) {
        $_SESSION['user_id'] = $row['id'];
        $_SESSION['is_admin'] = $row['is_admin'];
        header('Location: dashboard.php');
        exit;
    } else {
        $err = 'Invalid username or password';
    }
}
?>
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css">
<title>Login — Parts Research</title>
</head>
<body>
<div class="container">
  <h2>Sign in</h2>
  <?php if (!empty($err)) echo '<div class="error">'.htmlspecialchars($err).'</div>'; ?>
  <form method="post">
    <label>Username<br><input name="username" required></label>
    <label>Password<br><input name="password" type="password" required></label>
    <button type="submit">Sign in</button>
  </form>
</div>
</body>
</html>