<?php
require_once 'api_helper.php';
header('Content-Type: application/json');
if (empty($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Not authenticated']); exit;
}
$body = json_decode(file_get_contents('php://input'), true);
$q = trim($body['q'] ?? '');
$local_cost = floatval($body['local_cost'] ?? 0);
if ($q === '') { echo json_encode(['error'=>'Missing query']); exit; }
$part_norm = normalize_part($q);
// Try cached
$c = get_cached_query($part_norm);
if ($c) {
    // compute profit using cached median
    $metrics = compute_profit_metrics($c['median_price'], $local_cost);
    $c['profit'] = $metrics['profit'];
    echo json_encode(array_merge(['median_price'=>$c['median_price'],'sold_count'=>$c['sold_count']], $metrics, ['raw'=>$c]));
    exit;
}

try {
    $resp = marketplace_insights_search($q, 100);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]); exit;
}

// Parse response (best-effort — Marketplace Insights structure may vary)
$median = null; $sold_count = 0;
if (isset($resp['summary']) && isset($resp['summary']['medianPrice'])) {
    $median = floatval($resp['summary']['medianPrice']);
}
// fallback: attempt to extract median from items
if (!$median && isset($resp['items']) && is_array($resp['items'])) {
    $prices = array_map(function($it){ return floatval($it['price'] ?? 0); }, $resp['items']);
    $prices = array_filter($prices, function($p){ return $p>0; });
    sort($prices);
    if (count($prices)) {
        $mid = floor(count($prices)/2);
        $median = $prices[$mid];
        $sold_count = count($prices);
    }
}
if (!$median) $median = 0.0;
$result = ['median_price' => $median, 'sold_count' => $sold_count, 'raw' => $resp];
// cache
save_cached_query($part_norm, $q, $local_cost, $result);
$metrics = compute_profit_metrics($median, $local_cost);
$result['profit'] = $metrics['profit'];
$result = array_merge($result, $metrics);
echo json_encode($result);
?>