<?php
require_once 'api_helper.php';
if (empty($_SESSION['user_id']) || empty($_SESSION['is_admin'])) { header('Location: login.php'); exit; }
$db = get_db();
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $u = trim($_POST['username']); $p = trim($_POST['password']); $is_admin = !empty($_POST['is_admin']) ? 1 : 0;
    if ($u && $p) {
        $hash = password_hash($p, PASSWORD_DEFAULT);
        $stmt = $db->prepare('INSERT INTO users (username, password_hash, is_admin) VALUES (:u,:p,:a)');
        $stmt->execute([':u'=>$u,':p'=>$hash,':a'=>$is_admin]);
    }
}
$users = $db->query('SELECT id,username,is_admin,created_at FROM users ORDER BY created_at DESC')->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html><head><meta name="viewport" content="width=device-width,initial-scale=1"><link rel="stylesheet" href="assets/style.css"></head><body>
<div class="container"><h2>Users</h2>
<form method="post"><input type="hidden" name="action" value="add"><label>Username<br><input name="username" required></label><label>Password<br><input name="password" required></label><label><input type="checkbox" name="is_admin"> Admin</label><button type="submit">Add user</button></form>
<table><thead><tr><th>User</th><th>Admin</th><th>Created</th></tr></thead><tbody><?php foreach($users as $u) echo '<tr><td>'.htmlspecialchars($u['username']).'</td><td>'.($u['is_admin']? 'yes':'no').'</td><td>'.htmlspecialchars($u['created_at']).'</td></tr>'; ?></tbody></table>
<p><a href="dashboard.php">Back</a></p>
</div></body></html>